try(closeRolloutFloater ResetTransform_Floater)catch()

rollout ResetTransform_rol "ResetTransform" width:140 height:200
(
	radiobuttons Class_rab "" labels:#("EditablePoly","EditableMesh") pos:[12,5]
	checkbox PosReset_cbx "ʒu->[0,0,0]" checked:true
	checkbox RotReset_cbx "]->[0,0,0]" checked:true
	checkbox ScaleReset_cbx "XP[->[100,100,100]" checked:true
	checkbox KeepHierarchy_cbx "eqێ" checked:true
	checkbox KeepMaterial_cbx "}eAێ" checked:true
	button Transform_btn "s" pos:[15,135] width:80 height:24
	
	fn CreateBox box_class box_pos box_rot box_scale box_hie box_mat = (
		local obj_new_ary = #()
		local sel_ary = selection as array
		
		undo "ResetTransform" on
		(
			for o = 1 to sel_ary.count do(
				obj = sel_ary[o]
				
				local oriLayer = obj.INodeLayerProperties.layer
				local oriName = obj.name
				local oriColor = obj.wirecolor
				local oriPos = obj.pos
				local oriRot = obj.rotation
				local oriScale = obj.scale
				
				local baseBox = Box lengthsegs:1 widthsegs:1 heightsegs:1 pos:[0,0,0] isSelected:off
				convertTo baseBox PolyMeshObject
				polyop.deleteFaces baseBox #{1..6}
				if box_rot == false do baseBox.rotation = oriRot
				if box_scale == false do baseBox.scale = oriScale
				if box_pos == false do baseBox.pos = oriPos
				
				if(box_hie == true)do(
					local oriParent = obj.parent
					local oriChildren = obj.children
					baseBox.parent = oriParent
					for c in oriChildren do(
						c.parent = baseBox
					)
				)

				baseBox.EditablePoly.attach obj baseBox
				
				if(polyop.getNumFaces baseBox != 0)then(
					oriLayer.addnode baseBox
					baseBox.name = oriName
					baseBox.wirecolor = oriColor
					if box_mat == false do baseBox.material = undefined
					if box_class == 2 do convertTo baseBox TriMeshGeometry
					append obj_new_ary baseBox
				)else(
					delete baseBox
				)
			)
			obj_new_ary
		)
	)
	
	on Transform_btn pressed do(
		local sel = CreateBox Class_rab.state PosReset_cbx.checked RotReset_cbx.checked ScaleReset_cbx.checked \
			KeepHierarchy_cbx.checked KeepMaterial_cbx.checked
		select sel
	)
)

if ResetTransform_Floater != undefined then CloseRolloutFloater ResetTransform_Floater
ResetTransform_Floater = newRolloutFloater "ResetTransform" 210 190
addRollout ResetTransform_rol ResetTransform_Floater